import Vue from 'vue'
import App from './App.vue'
import router from './router'
import store from './store'

// 确保 Vue 在 WebSocket 管理器之前加载
import wsManager from './utils/websocket'
import './components/until/px2rem.js'
import { get, post, formData, downLoad, upload } from './api/http.js'
import ViewUI from 'view-design'
import 'view-design/dist/styles/iview.css'
import 'babel-polyfill'
import $ from "jquery"

import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import * as echarts from 'echarts';
import { message } from "@/api/message";

import Rsa from "@/api/rsa.js"
Vue.prototype.$Rsa = Rsa; //挂载到vue实例上

Vue.use(ElementUI);


Vue.prototype.$echarts = echarts;
Vue.prototype.message= message
Vue.prototype.$ = $


/**
 * 全局配置common方法
 */
Object.assign(Vue.prototype, {
 
  get,          //AJAX封装get请求
  post,         //AJAX封装post请求
  formData,     //AJAX封装formData请求
  downLoad,     //AJAX封装downLoad请求
  upload //
});

Vue.config.productionTip = false
Vue.use(ViewUI);

// 初始化 WebSocket 管理器
wsManager.setRouter(router)
if (!wsManager.wsConnected) {
  wsManager.initWebSocket()
}

new Vue({
  router,
  store,
  render: h => h(App)
}).$mount('#app')
