const CompressionWebpackPlugin = require('compression-webpack-plugin')
const isProduction = process.env.NODE_ENV === 'production'
const px2rem = require('postcss-px2rem')
const postcss = px2rem({
  remUnit: 100   //基准大小 baseSize，需要和rem.js中相同
})

module.exports = {
  productionSourceMap: false,    //生产环境是否生成 sourceMap 文件
  transpileDependencies: ['flv.js'],//单独声明flv 兼容IE
  // configureWebpack: config => {
  //   config.plugins.push(new CompressionWebpackPlugin({
  //     algorithm: 'gzip',
  //     test: /\.js$|\.html$|\.css/,
  //     threshold: 10240,
  //     minRatio: 0.8
  //   })
  //   )
  // }, 
  publicPath: '/',    //部署应用时的根路径(默认'/'),也可用相对路径(存在使用限制)
  outputDir: 'dist',        //运行时生成的生产环境构建文件的目录(默认'dist'，构建之前会被清除)
  assetsDir: '',        //静态资源目录(js、css、img、fonts)，相对outputDir的目录(默认'')
  indexPath: 'index.html', //指定生成index.html的输出路径(相对outputDir)也可以是绝对路径
  lintOnSave: false,                //是否开启ESlint（保存时检查）
  pages: {    //pages里配置的路径和文件名在你的文档目录必须存在，否则启动服务会报错
    index: {//除了 entry 之外都是可选的
      entry: 'src/main.js',        //page的主入口
      template: 'public/index.html',    //模板来源
      filename: 'index.html',            //在 dist/index.html 的输出
      //title在template中使用：<title><%=htmlWebpackPlugin.options.title%></title>
      title: '',
      chunks: ['chunk-vendors', 'chunk-common', 'index']
      // 在这个页面中包含的块，默认情况下会包含,提取出来的通用 chunk 和 vendor chunk
    },
    subpage: 'src/main.js'
    //官方解释：当使用只有入口的字符串格式时，模板会被推导为public/subpage.html
    //若找不到就回退到public/index.html，输出文件名会被推导为subpage.html
  },
  css: {
    // extract: true,        //是否使用css分离插件 ExtractTextPlugin
    sourceMap: false,    //开启 CSS source maps
    loaderOptions: {
      postcss: {
        plugins: [
          postcss
        ]
      }
    }, //css预设器配置项
    modules: false        //启用CSS modules for all css / pre-processor files.
  },
  devServer: {    //环境配置
    port: 8089,
    https: true,      //是否开启https
    hotOnly: true, //是否配置热更新
    open: true,      //配置自动启动浏览器
    proxy: {        //配置多个代理跨域(配置一个 proxy: 'http://localhost:4000' )
      '/sysm': {
        target: 'https://192.168.9.222:443',
        ws: true,  //是否跨域
        changeOrigin: true,
        pathRewrite: { '^/sysm': '/sysm' }
      },
      // '/sys': {
      //   target: 'http://192.168.9.133:80',
      //   ws: true,  //是否跨域
      //   changeOrigin: true,
      //   pathRewrite: { '^/sys': '/sys' }
      // },
      '/rtp': {
        target: 'https://192.168.0.218:8443',
        ws: true,  //是否跨域
        changeOrigin: true,
        pathRewrite: { '^/rtp': '/rtp' }
      },


    }
  },
  pluginOptions: {// 第三方插件配置
    // ...
  }
};
