export default (data, filename) => {
  if (!data) {
    console.error("文件内容为空");
    return
  }
  if (window.navigator.msSaveBlob) {  //此方法支持 IE10+ 
    var blobs = new Blob([data], { type: 'text/plain' });//创建一个blob对象
    try {
      window.navigator.msSaveBlob(blobs, filename); //此时为文件地址，如果返回二进制流要使用var url = new URL.createObjectURL(blobs);
    } catch (e) {
      console.log(e);
    }
  } else {   //其他浏览器使用a标签来进行下载
    let url = window.URL.createObjectURL(new Blob([data]))
    let link = document.createElement('a')
    link.style.display = 'none'
    link.href = url
    link.setAttribute('download', filename);
    document.body.appendChild(link)
    link.click();
  }

  // if (!data) {
  //   console.error("文件内容为空");
  //   return
  // }
  // let url = window.URL.createObjectURL(new Blob([data]))
  // let link = document.createElement('a')
  // link.style.display = 'none'
  // link.href = url
  // link.setAttribute('download', filename);
  // document.body.appendChild(link)
  // link.click();
}
