/**axios封装
 * 请求拦截、相应拦截、错误统一处理
 */
import axios from 'axios'
import QS from 'qs'
import { Message } from 'element-ui'
import router from '@/router'
let isFormData = false;
let isDownLoad = false;
let isJson = false;
//四网口部署配置
var protocol = window.location.protocol;
var domainPort = window.location.host;

var data = protocol + "//" + domainPort;
export const urlDZ = protocol + "//" + domainPort;
const axiosinstance = axios.create()
axiosinstance.defaults.baseURL = urlDZ + '/';

// 请求超时时间
axiosinstance.defaults.timeout = 20000
// 携带cookie
axiosinstance.defaults.withCredentials = true
// post请求头
axiosinstance.defaults.headers.post['Content-Type'] = 'application/json;charset=UTF-8'
// 请求拦截器
axiosinstance.interceptors.request.use(
  config => {
    // 获取token
    const token = sessionStorage.getItem('token')
    
    // 保留现有的请求头，并添加默认请求头
    config.headers = {
      'Content-Type': 'application/json',
      'Cache-Control': 'no-cache',
      //'Cache-Control':'no-store',
      'Pragma': 'no-cache',
      ...config.headers  // 保留传入的自定义请求头
    }
    
    // 如果存在token，添加到请求头
    if (token) {
      config.headers['Authorization'] = `Bearer ${token}`
    }
    
    if (isFormData) {
      axios.defaults.headers.post['Content-Type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
    } else {
      axios.defaults.headers.post['Content-Type'] = 'multipart/form-data'
    }
    if (isJson) {
      axios.defaults.headers.post['Content-Type'] = 'application/json'
    }
    if (isDownLoad) {
      config.responseType = 'blob';
    }
    return config
  },
  error => {
    return Promise.error(error)
  })

// 响应拦截器
axiosinstance.interceptors.response.use(
  response => {
    if (response.status === 200) {
      if (isDownLoad) {
        return Promise.resolve(response);
      }
      if (response.status === 200) {
        return Promise.resolve(response)
      } else if (response.status == 403) {
        return Promise.reject(response)
      } else if (response.status == 401) {
        return Promise.reject(response)
      } else {
        return Promise.reject(response)
      }
    } else {
      if (response.status == 401) {
        router.push("/sys/login");
      }
      return Promise.reject(response)
    }
  },
  // 服务器状态码不是200的情况
  error => {
    console.log('错误信息:', error.response.status)
    if (error.response.status == 403) {
      Message.closeAll();
      Message.error(error.response.data.msg);
      return;
    } else if (error.response.status == 401) {
      // alert("请登录！")
      Message.closeAll();
      Message.error(error.response.data.msg);
      router.push('/sys/login');
      // window.location.href = data;
      return;
    } else if (error.response.status == 409) {
      Message.error(error.response.data.msg);
      router.push('/sys/login');
      return;
    } else {
      // console.log('错误信息:', error.response.status)
      // console.log('错误信息:', error.response.data.msg)
      Message.closeAll();
      Message.error(error.response.data.msg);
      return Promise.reject(error.response);
    }

    // if (error.data && error.data.code) {
    //   switch (error.data.code) {
    //     // 401: 未登录
    //     // 未登录则跳转登录页面，并携带当前页面的路径
    //     // 在登录成功后返回当前页面，这一步需要在登录页操作。
    //     case 401:
    //       console.error('未登录');
    //       break
    //     case 403:
    //       console.error('登录过期，请重新登录')
    //       break
    //     case 404:
    //       console.error('网络请求不存在')
    //       break
    //     default:
    //       console.error(error.data.message)
    //   }
    //   return Promise.reject(error.data)
    // } else {
    //   return Promise.reject(error.response)
    // }
  }
)
/**
 * get方法，对应get请求
 * @param {String} url [请求的url地址]
 * @param {Object} params [请求时携带的参数]
 */
export function getNoJson(url, params) {
  isFormData = false
  isDownLoad = false
  isJson = false
  
  return new Promise((resolve, reject) => {
    axiosinstance.get(url, {
      params: params
    }).then(res => {

      resolve(res.data)
    }).catch(err => {
      reject(err)
    })
  })
}
/**
 * get方法，对应get请求
 * @param {String} url [请求的url地址]
 * @param {Object} params [请求时携带的参数]
 */
export function get(url, params) {
  isFormData = false
  isDownLoad = false
  isJson = false
  
  return new Promise((resolve, reject) => {
    axiosinstance.get(url, {
      params: JSON.stringify(params)
    }).then(res => {

      resolve(res.data)
    }).catch(err => {
      reject(err)
    })
  })
}

/**
 * post方法，对应post请求
 * @param {String} url [请求的url地址]
 * @param {Object} params [请求时携带的参数]
 */
export function post(url, params, config = {}) {
  isFormData = false
  isDownLoad = false
  
  return new Promise((resolve, reject) => {
    axiosinstance.post(
      url,
      JSON.stringify(params),
      config
    ).then(res => {

      resolve(res.data)
    }).catch(err => {

      reject(err)
    })
  })
}
/**
 * post方法，对应post请求
 * @param {String} url [请求的url地址]
 * @param {Object} params [请求时携带的参数]
 */
export function upload(url, params) {
  isFormData = false
  isDownLoad = false
  
  return new Promise((resolve, reject) => {
    axiosinstance.post(
      url,
      QS.stringify(params)
    ).then(res => {
      resolve(res.data)
    }).catch(err => {
      reject(err)
    })
  })
}
export function formData(url, params) {
  isFormData = true
  isDownLoad = false
  isJson = false
  
  return new Promise((resolve, reject) => {
    let formData = new FormData()
    for (let key in params) {
      formData.append(key, params[key])
    }
    
    axiosinstance.post(url, formData, { timeout: 600000 }
    ).then(res => {
      resolve(res.data)
    }).catch(err => {
      reject(err.data)
    })
  })
}
export function downLoad(url, params, config = {}) {
  isFormData = false
  isDownLoad = true
  isJson = false
  
  return new Promise((resolve, reject) => {
    axiosinstance.post(url, {
      params: params
    }, config).then(res => {
      resolve(res.data)
    }).catch(err => {
      reject(err.data)
    })
  });
}
