import { get, post, formData, upload, downLoad } from '@/api/http'

export default {
  baseinfo_get: params => post('/cgi-bin/system/baseinfo_get.cgi', params), // 获取设备基本信息

  user_get: params => post('/cgi-bin/system/user_get.cgi', params), // 用户获取
  user_add: params => post('/cgi-bin/system/user_add.cgi', params), // 用户添加
  user_edit: params => post('/cgi-bin/system/user_edit.cgi', params), // 用户修改
  user_delete: params => post('/cgi-bin/system/user_del.cgi', params), // 用户删除


  restart: params => post('/cgi-bin/system/restart.cgi', params), // 重启
  heartbeat: params => get('/cgi-bin/system/heartbeat.cgi', params), // 查看连接状态
  upgrade: params => formData('/cgi-bin/system/upgrade.cgi', params), // 升级

  device: params => get('/cgi-bin/system/init_device.cgi', params), // 恢复出厂设置




  time_get: params => get('/cgi-bin/system/time_get.cgi', params), // 时间配置显示
  timezone_get: params => get('/cgi-bin/system/timezone_get.cgi', params), // 获取时区
  timeTest_get: params => post('/cgi-bin/system/timeTest_get.cgi', params), // ntp测试
  time_save: params => post('/cgi-bin/system/time_save.cgi', params), //时间配置保存



  logDiagnostic_down: '/cgi-bin/system/logDiagnostic_down.cgi',//日志导出




  logType: params => post('/cgi-bin/system/logType_get.cgi', params), // 日志类型获取
  // findminor: params => post('/cgi-bin/system/log_findminor.cgi', params), // 日志查询次要类型
  logFind: params => post('/cgi-bin/system/log_get.cgi', params), //查询日志列表




  quit: params => get('/cgi-bin/system/quit.cgi', params), //退出登录

  log_down: params => downLoad('/cgi-bin/system/log_down.cgi', params), //日志导出
}