import { get, post, formData, upload, downLoad } from '@/api/http'

export default {
    
    webAuthLogout: params => post('/sysm/v1/webAuth/logout', params), //退出登录
//系统初始化
    systemInit: params => post('/sysm/v1/system/init', params), //系统初始化


    //CA初始化
    getSystemInfo: params => get('/sysm/v1/webAuth/getSystemInfo', params), //获取系统信息
    bootstrap: params => post('/sysm/v1/init/bootstrap', params), //CA初始化引导     
    create: params => post('/sysm/v1/init/create', params), //创建CA超级管理员

    genUkey: params => get('/sysm/v1/tmp/genUkey', params), //获取ukey信息

    webAuthBootstrap: params => get('/sysm/v1/webAuth/bootstrap', params), //二次认证    
    ukeySign: params => post('/sysm/v1/tmp/ukeySign', params), //ukey签名

    verifySign: params => post('/sysm/v1/webAuth/verifySign', params), //登录
    

    //用户管理
    queryUser: params => get('/sysm/v1/user/query', params), //查询用户
    createUser: (params, config) => post('/sysm/v1/user/create', params, config), //创建用户  
    freezeUser: params => post('/sysm/v1/user/freeze', params), //冻结用户
    unfreezeUser: params => post('/sysm/v1/user/unfreeze', params), //解冻用户
    queryRole: params => get('/sysm/v1/user/queryRole', params), //查询角色
    disableUser: (params, config) => post('/sysm/v1/user/disable', params, config), //禁用用户
    enableUser: (params, config) => post('/sysm/v1/user/enable', params, config), //启用用户
    deleteUser: (params, config) => post('/sysm/v1/user/delete', params, config), //删除用户
 
    unlockUser: (params, config) => post('/sysm/v1/user/unlock', params, config), //解锁用户
    //系统监控
    queryMonitor: params => get('/sysm/v1/monitor/query', params), //查询系统监控
    queryNicLink: params => get('/sysm/v1/monitor/queryNicLink', params), //查询网络链路
   
    

    //系统运维-网络配置
    queryNetCard: params => get('/sysm/v1/config/queryNetCard', params), //查询网卡
    modifyNetCard: params => post('/sysm/v1/config/modifyNetCard', params), //修改网卡
    toggleNetCard: params => post('/sysm/v1/config/toggleNetCard', params), //启用/禁用网卡
    
    //系统运维-服务启停
    querySSH: params => get('/sysm/v1/ssh/querySSH'), //查询SSH
    updateSSH: params => post('/sysm/v1/ssh/updateSSH', params), //修改SSH
    restartSSH: params => post('/sysm/v1/service/restart', params), //重启SSH

    //系统运维-升级维护
    uploadUpgrade: params => formData('/sysm/v1/upgrade/upload', params), //上传升级文件
    

    //日志配置-日志存储
    queryLog: params => get('/sysm/v1/config/queryLog'), //查询日志存储
    modifyLog: params => post('/sysm/v1/config/modifyLog', params), //修改日志存储


    checkUKeyExist: params => post('/sysm/v1/user/checkUKeyExist', params), //检查UKey是否存在
    completePinChange: params => post('/sysm/v1/webAuth/completePinChange', params), //完成密码修改
}


