import Vue from 'vue'
import store from '../store'
import VueRouter from 'vue-router'
import { setCookie, getCookie } from '@/components/cookie'
Vue.use(VueRouter)

const routes = [
  {
    path: '/sys/login',
    name: 'Login',
    meta: {
      checkLogined: false
    },
    component: resolve => require([('@/views/login')], resolve)
  },
  {
    path: '/sys/init',
    name: 'init',
    meta: {
      checkLogined: false
    },
    component: resolve => require([('@/views/init')], resolve)
  },
  {
    path: '/sys/system',
    name: 'System',
    component: () => import('@/views/system.vue'),
    children: [
      {
        path: 'monitor',
        name: 'SystemMonitor',
        component: () => import('@/views/system/monitor.vue')
      },
      {
        path: 'configManage',
        name: 'ConfigManage',
        component: () => import('@/views/system/configManage.vue')
      },
      {
        path: 'security/config',
        name: 'SecurityConfig',
        component: () => import('@/views/system/security/config.vue')
      },
      {
        path: 'security/blacklist',
        name: 'BlacklistManage',
        component: () => import('@/views/system/security/blacklist.vue')
      },
      {
        path: 'alarm/strategy',
        name: 'AlarmStrategy',
        component: () => import('@/views/system/alarm/strategy.vue')
      },
      {
        path: 'alarm/notification',
        name: 'NotificationService',
        component: () => import('@/views/system/alarm/notification.vue')
      },
      {
        path: 'alarm/receiver',
        name: 'ReceiverManage',
        component: () => import('@/views/system/alarm/receiver.vue')
      },
      {
        path: 'log/report',
        name: 'LogReport',
        component: () => import('@/views/system/log/report.vue')
      },
      {
        path: 'log/receive',
        name: 'LogReceive',
        component: () => import('@/views/system/log/receive.vue')
      },
      {
        path: 'log/storage',
        name: 'LogStorage',
        component: () => import('@/views/system/log/storage.vue')
      },
      {
        path: 'dataOverview',
        name: 'DataOverview',
        component: () => import('@/views/system/dataOverview.vue')
      },
      {
        path: 'business/interface',
        name: 'InterfaceManage',
        component: () => import('@/views/system/business/interface.vue')
      },
      {
        path: 'business/device',
        name: 'DeviceManage',
        component: () => import('@/views/system/business/device.vue')
      },
      {
        path: 'business/check',
        name: 'DeviceCheck',
        component: () => import('@/views/system/business/check.vue')
      },
 
      {
        path: 'key/encrypt',
        name: 'KeyEncrypt',
        component: () => import('@/views/system/key/encrypt.vue')
      },
      {
        path: 'key/user',
        name: 'UserKey',
        component: () => import('@/views/system/key/user.vue')
      },
      {
        path: 'key/history',
        name: 'KeyHistory',
        component: () => import('@/views/system/key/history.vue')
      },
      {
        path: 'key/archive',
        name: 'KeyArchive',
        component: () => import('@/views/system/key/archive.vue')
      },
      {
        path: 'log/operation',
        name: 'LogOperation',
        component: () => import('@/views/system/log/operation.vue')
      },
      {
        path: 'log/analysis',
        name: 'LogAnalysis',
        component: () => import('@/views/system/log/analysis.vue')
      },
      {
        path: 'user/list',
        name: 'UserList',
        component: () => import('@/views/system/user/list.vue')
      },
      {
        path: 'manage/online',
        name: 'OnlineUsers',
        component: () => import('@/views/system/manage/online.vue')
      },
      {
        path: 'manage/whitelist',
        name: 'BusinessWhitelist',
        component: () => import('@/views/system/manage/whitelist.vue')
      },
      {
        path: 'manage/cascade',
        name: 'CascadeManage',
        component: () => import('@/views/system/manage/cascade.vue')
      },
      {
        path: 'certificate/manage',
        name: 'CertificateManage',
        component: () => import('@/views/system/certificate/manage.vue')
      },
      {
        path: 'certificate/apply',
        name: 'CertificateApply',
        component: () => import('@/views/system/certificate/apply.vue')
      },
      {
        path: 'certificate/issued',
        name: 'CertificateIssued',
        component: () => import('@/views/system/certificate/issued.vue')
      },
      {
        path: 'certificate/template',
        name: 'CertificateTemplate',
        component: () => import('@/views/system/certificate/template.vue')
      },
      {
        path: 'certificate/extension',
        name: 'CertificateExtension',
        component: () => import('@/views/system/certificate/extension.vue')
      },
      {
        path: 'certificate/crl',
        name: 'CertificateCRL',
        component: () => import('@/views/system/certificate/crl.vue')
      },
      {
        path: 'certificate/arl',
        name: 'CertificateARL',
        component: () => import('@/views/system/certificate/arl.vue')
      },
      {
        path: 'certificate/application',
        name: 'CertificateApplication',
        component: () => import('@/views/system/certificate/application.vue')
      },
      {
        path: 'certificate/service',
        name: 'CertificateService',
        component: () => import('@/views/system/certificate/service.vue'),
        meta: { title: '服务配置' }
      },
      {
        path: 'certificate/archive/history',
        name: 'CertificateHistory',
        component: () => import('@/views/system/archive/history.vue'),
        meta: { title: '历史证书' }
      },
      {
        path: 'certificate/archive/record',
        name: 'CertificateRecord',
        component: () => import('@/views/system/archive/record.vue'),
        meta: { title: '证书归档记录' }
      },
      {
        path: 'certificate/tools/parse',
        name: 'CertificateParse',
        component: () => import('@/views/system/tools/parse.vue'),
        meta: { title: '证书解析' }
      },
      {
        path: 'certificate/tools/verify',
        name: 'CertificateVerify',
        component: () => import('@/views/system/tools/verify.vue'),
        meta: { title: '证书校验' }
      },
      {
        path: 'certificate/tools/csrParse',
        name: 'CsrParse',
        component: () => import('@/views/system/tools/csrParse.vue'),
        meta: { title: 'CSR证书解析' }
      },
      {
        path: 'log/backup',
        name: 'LogBackup',
        component: () => import('@/views/system/log/backup.vue'),
        meta: { title: '备份与恢复' }
      },
      {
        path: 'businessConfiguration/auth',
        name: 'BusinessAuth',
        component: () => import('@/views/system/businessConfiguration/auth.vue'),
        meta: { title: '业务认证' }
      },
      {
        path: 'businessConfiguration/whitelist',
        name: 'BusinessWhitelist',
        component: () => import('@/views/system/businessConfiguration/whitelist.vue'),
        meta: { title: '业务白名单' }
      },
      {
        path: 'ra/init',
        name: 'RAInit',
        component: () => import('@/views/system/ra/init.vue'),
        meta: { title: 'RA初始化' }
      },
      {
        path: 'ra/apply',
        name: 'CertificateApply',
        component: () => import('@/views/system/ra/apply.vue'),
        meta: { title: '证书申请' }
      },
      {
        path: 'ra/batchApply',
        name: 'BatchApply',
        component: () => import('@/views/system/ra/batchApply.vue'),
        meta: { title: '证书批量申请' }
      },
      {
        path: 'ra/status',
        name: 'ApplyStatus',
        component: () => import('@/views/system/ra/status.vue'),
        meta: { title: '申请状态' }
      },
      {
        path: 'ra/issuedList',
        name: 'IssuedList',
        component: () => import('@/views/system/ra/issuedList.vue'),
        meta: { title: '已签发证书列表' }
      },
      {
        path: 'ra/audit',
        name: 'CertAudit',
        component: () => import('@/views/system/ra/audit.vue'),
        meta: { title: '证书审核' }
      }
    ]
  },
  // {
  //   path: '/Navbar',
  //   name: 'index',
  //   meta: {
  //     checkLogined: false
  //   },
  //   component: resolve => require([('@/views/bakeStage/Navbar')], resolve),
  //   children: [
  //     {
  //       path: "/Navbar/system/systemSet",
  //       name: "systemSet",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/system/systemSet.vue")
  //     }, {
  //       path: "/Navbar/system/systemMaintenance",
  //       name: "systemMaintenance",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/system/systemMaintenance.vue")
  //     }, {
  //       path: "/Navbar/system/user",
  //       name: "user",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/system/user.vue")
  //     }, {
  //       path: "/Navbar/network/basicSet",
  //       name: "basicSet",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/network/basicSet.vue")
  //     }, {
  //       path: "/Navbar/device/nvrdevice",
  //       name: "nvrdevice",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/device/nvrdevice.vue")
  //     }, {
  //       path: "/Navbar/device/videodevice",
  //       name: "videodevice",
  //       meta: {
  //         checkLogined: true
  //       },
  //       component: () => import("@/views/bakeStage/device/videodevice.vue")
  //     },


  //   ]
  // },






]

const router = new VueRouter({
  routes,
  mode: "history"
})

// router.beforeEach((to, from, next) => {
//   if (to.meta.checkLogined) {
//     if (getCookie('token') == null) {
//       next({
//         path: '/'
//       })
//     } else {
//       next();
//     }
//   } else { //如果不需要登录
//     next();
//   }
// })



export default router
